//
//  TTTGameViewController.m
//  Tic-Tac-Toe-Storyboard
//
//  Created by Rajiv Ramnath on 9/2/13.
//  Copyright (c) 2013 Rajiv Ramnath. All rights reserved.
//

#import "TTTGameSessionViewController.h"
#import "TTTBoard.h"
#import "TTTGameView.h"
#import "TTTGame.h"

@implementation TTTGameSessionViewController

@synthesize boardView;
@synthesize scoreTextField;
@synthesize turnTextField;

    - (id)initWithNibName:(NSString *)nibNameOrNil
                   bundle:(NSBundle *)nibBundleOrNil
    {
        self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
        if (self) {
            // Custom initialization
        }
        return self;
    }

    - (void) initializeGameSession{
        firstPlayerName = @"Player 1";
        secondPlayerName = @"Player 2";
        scorePlayerOne=0;
        scorePlayerTwo=0;
        scoreTextField.enabled = NO;
        turnTextField.enabled=NO;
        [boardView setGameSession:self];
    }

    - (void) playNewGame{
        activeGame = [[TTTGame alloc] init];
        [activeGame setPlayerNames:firstPlayerName :secondPlayerName];
        
        TTTGameGrid *gameGrid = [activeGame getGameGrid];
        [boardView setGrid:gameGrid];
        
        gameView = [[TTTGameView alloc] init];
        [gameView setGameViewComponents :boardView :turnTextField :scoreTextField];

        [gameView showScores :[activeGame getPlayerOneName] :scorePlayerOne
                             :[activeGame getPlayerTwoName] :scorePlayerTwo];
        
        NSString *statusMessage = [[NSArray arrayWithObjects :[activeGame getCurrentPlayerName],
                                                              @"to play",
                                                              nil]
                                   componentsJoinedByString:@" "];
        [gameView setGameStatus :statusMessage];
        
        [gameView redraw];
    }

    - (void) accumulateScores: (NSString *) winningPlayerName{
        if(winningPlayerName==firstPlayerName)
            scorePlayerOne++;
        else
            scorePlayerTwo++;
    }


    - (void) proceedToFinish {

         NSString *winningPlayerName;
         NSString *alertMessage=nil;
        
         if([activeGame isWon]) {
             winningPlayerName = [activeGame getWinningPlayerName];
             alertMessage = [[NSArray arrayWithObjects :winningPlayerName,
                                         @"Wins!",
                                         nil]
                                        componentsJoinedByString:@" "];
             [gameView setGameStatus:alertMessage];
             [self accumulateScores:winningPlayerName];
             [gameView showScores :firstPlayerName :scorePlayerOne :secondPlayerName :scorePlayerTwo];
        } else if([activeGame isDrawn]) {
            alertMessage = @"Draw!";
            [gameView setGameStatus:alertMessage];
         }
        
        [gameView promptToProceed:self];
    }

    - (void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex{
        if (buttonIndex == 0){
            [self playNewGame];
        } else if (buttonIndex == 1) {
            [self dismissViewControllerAnimated:YES completion:nil];
        }
    }

    - (void) humanTakesATurn :(int) x :(int) y {// human's turn
        BOOL successfulPlay = [activeGame play :x :y]; // update the model
        if (successfulPlay){
            [gameView placeSymbol :x :y]; // Refresh the display
            if([activeGame isActive]){
                NSString *statusMessage = [[NSArray arrayWithObjects :[activeGame getCurrentPlayerName],
                                            @"to play",
                                            nil]
                                           componentsJoinedByString:@" "];
                [gameView setGameStatus:statusMessage];
                // scheduleAndroidsTurn();
            } else {
                [self proceedToFinish];
            }
        } // else do nothing and return
    }

    - (void) boardTouchedAt:(float)x :(float)y {
        int posX=0, posY=0;
        if( x > [boardView getWidth] && x < [boardView getWidth] * 2 ) posX = 1;
        if( x > [boardView getWidth] * 2 && x < [boardView getWidth] * 3 ) posX = 2;
        if( y > [boardView getHeight] && y < [boardView getHeight] * 2 ) posY = 1;
        if( y > [boardView getHeight] * 2 && y < [boardView getHeight] * 3 ) posY = 2;

        [self humanTakesATurn:posX :posY];
    }

    - (void)viewDidLoad{
        [super viewDidLoad];
        // Do any additional setup after loading the view.
        [self initializeGameSession];
        [self playNewGame];
    }

    - (void)didReceiveMemoryWarning{
        [super didReceiveMemoryWarning];
        // Dispose of any resources that can be recreated.
    }

@end
